package emps;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie2a {
	
	public static void main(String[] args) {
		final List<Employee> emps = ObslugaCSV.wczytaj();
		
		final Map<String, Integer> sumy = new HashMap<>();
		final Map<String, Integer> ilosci = new HashMap<>();
				
		for(Employee emp : emps) {
			final String jobTitle = emp.getJobTitle();
			if(sumy.containsKey(jobTitle)) {
				// to jest kolejny pracownik z tego stanowiska → zwiększamy wartość w słowniku
				int suma = sumy.get(jobTitle);
				sumy.put(jobTitle, suma + emp.getSalary());
				int ile = ilosci.get(jobTitle);
				ilosci.put(jobTitle, ile + 1);
			} else {
				// to jest pierwszy pracownik z tego stanowiska → wpisujemy jego pensję jako wartość początkową
				sumy.put(jobTitle, emp.getSalary());
				ilosci.put(jobTitle, 1);
			}
		}
		
		for(String job : sumy.keySet()) {
			int ile = ilosci.get(job);
			int suma = sumy.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("%-32s | %2d | %8.2f\n", job, ile, srednia);
		}
	}

}
