package emps;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Grupowanie2 {
	// Tutaj mamy pokazany standardowy schemat "grupowania za pomocą słowników".
	// Używamy poleceń dostepnych w tej formie od Javy 5.
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		Map<String, Integer> sumy = new HashMap<>();
		Map<String, Integer> ilosci = new HashMap<>();
				
		for(Employee emp : emps) {
			if(sumy.containsKey(emp.getJobTitle())) {
				// to jest kolejny pracownik z tego stanowiska → zwiększamy wartość w słowniku
				int suma = sumy.get(emp.getJobTitle());
				sumy.put(emp.getJobTitle(), suma + emp.getSalary());
				int ile = ilosci.get(emp.getJobTitle());
				ilosci.put(emp.getJobTitle(), ile + 1);
			} else {
				// to jest pierwszy pracownik z tego stanowiska → wpisujemy jego pensję jako wartość początkową
				sumy.put(emp.getJobTitle(), emp.getSalary());
				ilosci.put(emp.getJobTitle(), 1);
			}
		}
		
		// System.out.println(sumy);
		
		for(String job : sumy.keySet()) {
			int ile = ilosci.get(job);
			int suma = sumy.get(job);
			double srednia = (double)suma / ile;
			System.out.printf("%-32s | %2d | %8.2f\n", job, ile, srednia);
		}
	}

}
