package emps;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Grupowanie1 {
	// W tej wersji najpierw ustalamy, jakie są joby, a następnie dla każdego joba od nowa przeglądamy dane
	// To nie jest optymalne pod kątem wydajności.
	// Mając 19 jobów i 107 pracowników, tę linię, w której jest if wykonamy aż 19×107 razy.

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		// etap 1: zbieramy nazwy jobów bez powtórzeń
		Set<String> jobs = new HashSet<>();
		for(Employee emp : emps) {
			jobs.add(emp.getJobTitle());
		}
		
		// etap 2: dla każdego joba przeglądamy listę empsów i wybieramy tych pracowników, którzy mają taki job
		for(String job : jobs) {
			double suma = 0;
			int ile = 0;
			for(Employee emp : emps) {
				if(emp.getJobTitle().equals(job)) {
					suma += emp.getSalary();
					ile++;
				}
			}
			double srednia = suma / ile;
			System.out.printf("%-32s | %2d | %8.2f\n", job, ile, srednia);
		}
	}

}
