package emps;

import java.util.List;


public class FiltrowanieMapowanie {
	// Ten zapis to jest tzw. "pipeline", na który składają się:
	// - źródło (w tym przypadku emps.stream() - źródłem danych jest lista)
	// - operacje pośrednie (intermediate operations) - tutaj najbardziej typowe, czyli filter i map
	// - operacja końcowa (terminal operation) - tutaj jest to forEach
	
	// Ważny szczegół: w pewnym miejscu zmienia się typ danych. Najpierw jest to strumień Employees,
	// a za pierwszym map pojawia się strumień Stringów
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();

		emps.parallelStream()
			.filter(emp -> emp.getSalary() < 10000)
			.map(emp -> emp.getFirstName() + " " + emp.getLastName() +
					" z miasta " + emp.getCity() + " zarabia " + emp.getSalary())
			.filter(s -> s.contains("K"))	// .map(s -> s.toUpperCase())
			.map(String::toUpperCase)
			//.forEach(System.out::println);

			.findAny().ifPresent(System.out::println);
	}

}
