package emps;

import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class FGrupowanie3 {
	// W tej wersji dla każdej grupy wyliczamy "statystyki".
	// Niezależnie od tego do kolektora groupingBy przekazuję też parametr TreeMap::new
	// co powoduje użycie TreeMap zamiast HashMap
	
	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		Map<String, IntSummaryStatistics> grupy = emps.stream()
				.collect(Collectors.groupingBy(Employee::getJobTitle,
						TreeMap::new, // () -> new TreeMap()
						Collectors.summarizingInt(Employee::getSalary)));
		
		// grupy.forEach((job, statystyki) -> System.out.printf("%-32s → %s\n", job, statystyki));
		
        grupy.forEach((job, stats) -> System.out.printf("| %-32s | %2d | %5d | %8.2f | %5d |%n",
                job, stats.getCount(), stats.getMin(), stats.getAverage(), stats.getMax()));

	}

}
