package emps;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FGrupowanie2 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		// Jeśli do groupingBy jako drugi parametr przekażemy kolektor, to mówi on "co zrobić z każdą grupą".
		// Przykładowo liczymy średnią pensję pracowników w grupie.
		Map<String, Double> grupy = emps.stream()
				.collect(Collectors.groupingBy(Employee::getJobTitle,
						Collectors.averagingInt(Employee::getSalary)));
		
		grupy.forEach((job, srednia) -> {
			System.out.printf("%-32s → %8.2f\n", job, srednia);
		});	
	}

}
