package emps;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FGrupowanie1 {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		Map<String, List<Employee>> grupy = emps.stream().collect(Collectors.groupingBy(Employee::getJobTitle));
		// groupingBy wywołany w najprostszy sposób daje w wyniku słownik, w którym
		// dla określonej wartości klucza (np. "Programmer") zapisana jest lista wszystkich rekordów, które należą do tej grupy
		
		// Zawartość słownika przejrzymy w sposób oparty o wyrażenia lambda, operacją forEach
		grupy.forEach((job, lista) -> {
			System.out.println("Pracownicy typu " + job + ":");
			lista.forEach(emp -> {
				System.out.println(" * " + emp.getFirstName() + " " + emp.getLastName());
			});
			System.out.println();
		});
		
	}

}
