package emps;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class F7_UnikalneMiasta {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj();
		
		// podejście 1 - tworzymy Set
		Set<String> miasta = emps.stream()
				.map(Employee::getCity)
				.collect(Collectors.toSet());
		
		System.out.println("Mam zbiór o rozmiarze " + miasta.size());
		miasta.forEach(m -> System.out.println("- " + m));
		
		System.out.println();
		
		// podejście 2 - usuwanie duplikatów i wypisywanie "w locie"
		emps.stream()
			.map(Employee::getCity)
			.distinct()
			.forEach(m -> System.out.println("* " + m));
	}

}
