package emps;

import javax.swing.*;
import java.util.List;
import java.util.OptionalDouble;

public class F4b_SredniaJob {
    public static void main(String[] args) {
        String szukanyJob = JOptionPane.showInputDialog("Podaj nazwę stanowiska", "Programmer");
        if(szukanyJob == null) {
            return;
        }

        List<Employee> emps = ObslugaCSV.wczytaj();

        OptionalDouble avg = emps.stream()
                .filter(emp -> szukanyJob.equalsIgnoreCase(emp.getJobTitle()))
                .mapToInt(Employee::getSalary)
                .average();

        if(avg.isPresent()) {
            JOptionPane.showMessageDialog(null,
                    "Średnia pracowników typu " + szukanyJob + " wynosi " + avg.getAsDouble());
        } else {
            JOptionPane.showMessageDialog(null,
                    "Nie ma pracowników typu " + szukanyJob, "Brak danych", JOptionPane.WARNING_MESSAGE);
        }
    }
}
