package emps;

import java.util.List;
import java.util.stream.Collectors;

public class F3_SredniaWszystkich {
    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();

        double avg = emps.stream()
                .mapToInt(Employee::getSalary)
                .average()
                .orElse(0);
        System.out.println(avg);
        // zamiast Employee::getSalary można też napisać emp -> emp.getSalary()

        // Można też użyć dedykowanego Collectora
        Double avg2 = emps.stream().collect(Collectors.averagingInt(Employee::getSalary));
        System.out.println(avg2);
    }
}
