package emps;

import java.util.List;

public class F1_WypiszWybranePola {
    public static void main(String[] args) {
        List<Employee> emps = ObslugaCSV.wczytaj();

        // podejście 1: forEach bezpośrednio na liście
//        emps.forEach(emp -> System.out.printf("%s %s (%s) zarabia %d%n",
//                emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary()));

        // podejście 2: najpierw mapujemy obiekty Employee na obiekty String, a następnie wypisujemy w prosty sposób
        emps.stream()
                .map(emp -> String.format("%s %s (%s) zarabia %d",
                        emp.getFirstName(), emp.getLastName(), emp.getJobTitle(), emp.getSalary()))
                .forEach(System.out::println);
    }
}
