package sprzedaz.wydajnosc;

import java.io.File;
import java.io.IOException;
import java.util.List;

// Wydzielenie wczytywaia do oddzielnej klasy MaszynaWczytujaca.
// W tamtej klasie zamiast HashMap używany jest ConcurrentHashMap. Używam tam też nowych operacji na mapach - computeIfAbsent.
public class WczytajSprzedaz7 {
	public static void main(String[] args) {
		Pomiary.wypiszPamiec();

		Opakowanie<List<Transakcja>> wynik = Opakowanie.empty();

		System.out.println("\nczytam");
		File plik = new File("sprzedaz_100.txt");
		
		Pomiary.zmierzCzasDzalania(() -> {
			try {
				List<Transakcja> lista = MaszynaWczytujaca.wczytajCalyPlik(plik);
				wynik.set(lista); // aby GC nie usunął listy
				System.out.println("Wczytano " + lista.size());
			} catch (IOException e) {
				e.printStackTrace();
			}
		});
		Pomiary.wypiszPamiec();

		System.out.println("\ngc");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
		System.out.println(wynik.get().size());
	}

}
