package sprzedaz.wydajnosc;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

/* W tej wersji dane są czytane stumieniowo (Files.lines) i od razu przetwarzane. */
public class CzytajILicz3 {
	
	static void calaRobota() {
		try {
			File plik = new File("sprzedaz_100.csv");
			MaszynaWczytujaca maszynaWczytujaca = new MaszynaWczytujaca();
			
			Map<String, BigDecimal> sumy = Files.lines(plik.toPath())
				.map(maszynaWczytujaca::wczytajJedenRekord)
				.collect(Collectors.groupingBy(Transakcja::getMiasto,
					Collectors.mapping(Transakcja::getWartosc,
						Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
					
				sumy.forEach((k, v) -> System.out.printf(Locale.US, "%12s - %12.2f\n", k, v));
				System.out.println();
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		Pomiary.zmierzCzasDzalania(CzytajILicz3::calaRobota);
		Pomiary.wypiszPamiec();
		System.out.println("gc...");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
	}

}
