package sprzedaz.strumieniowo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

// To jest przykład "klasy narzędziowej" / "utility class".
// Klasa zawiera różne operacje, jest takim zestawem metod.
public class ObslugaCSV {
    private static final String SEP = ",";
	
	private ObslugaCSV() {
		// nie należy tworzyć obiektów tej klasy
	}

	// Gdy w klasie jest kilka metod o tej samej nazwie, ale różniących się listą parametrów
	// to jest to "przeciążanie" - overloading.
	public static List<Transakcja> wczytaj(String sciezka) {
		return wczytaj(new File(sciezka));
	}

	public static List<Transakcja> wczytaj(File plik) {
		List<Transakcja> lista = new ArrayList<>();
		try(Scanner scanner = new Scanner(plik)) {
			scanner.nextLine();
			while(scanner.hasNextLine()) {
				String linia = scanner.nextLine();
				String[] t = linia.split(SEP);
				Transakcja transakcja = new Transakcja(LocalDate.parse(t[0]), t[1], t[2], t[3], t[4],
						new BigDecimal(t[5]), Integer.parseInt(t[6]));
				lista.add(transakcja);
			}
		} catch(FileNotFoundException e) {
			e.printStackTrace();
		}
		return lista;
	}
	

    public static void zapisz(List<Transakcja> transakcje, String sciezka) {
        zapisz(transakcje, new File(sciezka));
    }
    
    public static void zapisz(List<Transakcja> transakcje, File plik) {
        try(PrintWriter out = new PrintWriter(plik)) {
            for(Transakcja tr : transakcje) {
                out.print(tr.getData());
                out.print(SEP);
                out.print(tr.getMiasto());
                out.print(SEP);
                out.print(tr.getSklep());
                out.print(SEP);
                out.print(tr.getKategoria());
                out.print(SEP);
                out.print(tr.getTowar());
                out.print(SEP);
                out.print(tr.getCena());
                out.print(SEP);
                out.print(tr.getSztuk());
                out.println();
            }
        } catch(FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}
