package sprzedaz.obiektowo;

import java.text.Collator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class P3_Miasta_v2 {
    
    // Miast jest tylko 8 i tu jeszcze nie widać róznicy w działaniu, ale generalnie dla zbiorów (Set)
    // sprawdzanie czy element należy do zbioru oraz zapewnianie unikalności jest szybsze niż dla list.
    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");
        //Set<String> miasta = new HashSet<>(); // dowolnie zmienia kolejność
        //Set<String> miasta = new LinkedHashSet<>(); // zachowuje oryginalną kolejność (wg pierwszych wystapień)
        //Set<String> miasta = new TreeSet<>(); // kolejność posortowana, Ł na końcu
        Set<String> miasta = new TreeSet<>(Collator.getInstance()); // posortowane alfabetycznie wg języka polskiego
        
        // nanoTime - odczyt zegara systemowego.
        // robimy to po to, aby zmierzyć czas działania
        long p = System.nanoTime();
        for(Transakcja transakcja : transakcje) {
            // Set sam gwarantuje brak powtórzeń, więc w tej wersji nie trzeba pisać if
            miasta.add(transakcja.getMiasto());
        }
        long k = System.nanoTime();
        
        for(String miasto : miasta) {
            System.out.println(miasto);
        }
        System.out.printf("Czas: %.6f s\n", (k-p) * 1e-9);
    }

}



