package watki.podstawy;

import java.util.Random;

public class SumaTablicy1 {
	static long suma1, suma2;

	public static void main(String[] args) {
		final int N = 200_000_000;
		final int MAX = 1000;
		System.out.println("Tworzę tablicę i losuję liczby");
		
		Random random = new Random();
		int[] t = new int[N];
		
		for(int i = 0; i < t.length; i++) {
			t[i] = random.nextInt(MAX);
		}
		System.out.println("Przygotowuję wątki");

		// Wątek1 liczy sumę elementów od 0 do < N/2 i zapisuje wynik w zmiennej suma1
		// Wątek2 liczy sumę elementów od N/2 do < length i zapisuje wynik w zmiennej suma2
		
		Thread watek1 = new Thread(() -> {
			long sumaLokalna = 0;
			for(int i = 0; i < N/2; i++) {
				sumaLokalna += t[i];
			}
			suma1 = sumaLokalna;
		});

		Thread watek2 = new Thread(() -> {
			long sumaLokalna = 0;
			for(int i = N/2; i < N; i++) {
				sumaLokalna += t[i];
			}
			suma2 = sumaLokalna;
		});

		System.out.println("Liczę sumę");
		long p = System.nanoTime();
		
		watek1.start();
		watek2.start();
		
		try {
			watek1.join();
			watek2.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		long sumaLaczna = suma1 + suma2;
		long k = System.nanoTime();
		
		System.out.printf("suma: %d, czas: %.3f s\n", sumaLaczna, (k-p)/1e9);
	}

}
