package watki.podstawy;

public class PierwszeWatki {

	public static void main(String[] args) {
		System.out.println("Początek main");
		System.out.println("Tworzenie wątków...");
		
		// Runnable to jest "przepis" mówiący co ma robić robić wątek; treść wątku.
		Runnable przepisA = new Runnable() {
			public void run() {
				System.out.println("Początek AAA");
				for(int i = 1; i <= 100; i++) {
					System.out.println("AAA " + i);
				}
				System.out.println("Koniec AAA");
			}
		};
		
		// Obiekt Thread to jest wątek, czyli coś, co można uruchomić w ramach aplikacji i co działa "w tle", równolegle z innymi wątkami.
		// Najczęściej wątek tworzy się w oparciu o obiekt Runnable, który mówi "co ma robić wątek".
		Thread watekA = new Thread(przepisA);
		
		// Można klasy anonimowej użyć bez. w new Thread:
		Thread watekB = new Thread(new Runnable() {
			public void run() {
				System.out.println("Początek BBB");
				for(int i = 1; i <= 100; i++) {
					System.out.println("BBB " + i);
				}
				System.out.println("Koniec BBB");
			}
		});
		
		// Od Java 8 obiekty Runnable (czyli treść wątku) można podawać też jako wyrażenie lambda
		Thread watekC = new Thread(() -> {
			System.out.println("Początek CCC");
			for(int i = 1; i <= 100; i++) {
				System.out.println("CCC " + i);
			}
			System.out.println("Koniec CCC");
		});
		
		System.out.println("Wątki utworzone:");
		System.out.println(watekA);
		System.out.println(watekB);
		System.out.println(watekC);
		
		System.out.println("Uruchamiam wątki:");
		// wątki uruchamia się metodą start (UWAGA!!!!!! nie metodą run !!!!!)
		watekA.start();
		watekB.start();
		watekC.start();
		
		System.out.println("Wątki uruchomione");
		
		System.out.println("Koniec main");
	}

}
