package sklep.serwlety;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.persistence.TypedQuery;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import sklep.model.Product;

// Wersja ze wstrzykiwaniem EntityManagerFactory za pomocą adnotacji @PersistenceUnit.
// Jeśli w aplikacji jest tylko jeden persistence unit, to nazwy można nie podawać, ale ja wolę zawsze podać.
// Ta wersja jest odpowiednia także dla konfiguracji opartej o RESOURCE_LOCAL

@WebServlet("/lista2")
public class Lista2 extends HttpServlet {
	private static final long serialVersionUID = 1L;
	
	@PersistenceUnit(unitName="sklep")
	private EntityManagerFactory emf;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		EntityManager em = null;
		try {
			em = emf.createEntityManager();
			
			TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
			List<Product> products = query.getResultList();
			out.println("Odczytano " + products.size() + " rekordów:");
			for (Product product : products) {
				out.println(product.getProductName() + " " + product.getPrice());
			}
		} catch(Exception e) {
			out.println("Wyjątek: " + e + "\n");
			e.printStackTrace(out);
		} finally {
			if(em != null) em.close();
		}
	}

}
