package sklep.przyklady;

import java.math.BigDecimal;
import java.util.List;
import java.util.Scanner;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import sklep.model.Product;

public class P6_ParametryPozycyjne {

	public static void main(String[] args) {
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			Scanner sc = new Scanner(System.in);
			emf = Persistence.createEntityManagerFactory("sklep");
			em = emf.createEntityManager();

			System.out.print("Podaj  minimalną cenę: ");
			BigDecimal min = sc.nextBigDecimal();
			
			System.out.print("Podaj maksymalną cenę: ");
			BigDecimal max = sc.nextBigDecimal();
			
			// Parametry pozycyjne (numerowane) można podać, ale trzeba jawnie ponumerować w treści zapytania.
			// W początkowych wersjach technologii JPA/Persistence działały też parametry takie jak w JDBC: BETWEEN ? AND ?
			TypedQuery<Product> query = em.createQuery(
					"SELECT p FROM Product p WHERE p.price BETWEEN ?1 AND ?2",
					Product.class);
			query.setParameter(1, min);
			query.setParameter(2, max);
			List<Product> products = query.getResultList();
			System.out.println("Odczytano " + products.size() + " rekordów:");
			for (Product product : products) {
				System.out.println(" * " + product.getProductName() + " za " + product.getPrice());
			}
		} finally {
			if(em != null)
				em.close();
			if(emf != null)
				emf.close();
		}
	}
}
