package sklep.przyklady;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import sklep.model.Product;

public class P4_OdczytajWszystkieProdukty_NamedQuery {

	public static void main(String[] args) {
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			emf = Persistence.createEntityManagerFactory("sklep");
			em = emf.createEntityManager();
			
			// Poprzez nazwę wskazujemy jedno z zapytań zdefiniowanych w projekcie w adnotacji @NamedQuery
			TypedQuery<Product> query = em.createNamedQuery("Product.findAll", Product.class);
			List<Product> products = query.getResultList();
			System.out.println("Odczytano " + products.size() + " produktów:");
			for (Product product : products) {
				System.out.println(" * " + product.getProductName() + " za " + product.getPrice());
			}
			
		} catch(Exception e) {
			System.out.println("Katastrofa " + e);
			e.printStackTrace();
		} finally {
			if(em != null) em.close();
			if(emf != null) emf.close();
		}
	}

}
