package sklep.przyklady;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

import sklep.model.Product;

public class P3_OdczytajWszystkieProdukty_JPQL {

	public static void main(String[] args) {
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			emf = Persistence.createEntityManagerFactory("sklep");
			em = emf.createEntityManager();
			
			// JPQL - Java Persistence Query Language (aka HQL)
			// Języka zapytań wzorowany na SQL, ale odnoszący do nazw klas i pól takich, jakei są w Javie.
			TypedQuery<Product> query = em.createQuery("SELECT p FROM Product p ORDER BY p.productId", Product.class);
			List<Product> products = query.getResultList();
			System.out.println("Odczytano " + products.size() + " produktów:");
			for (Product product : products) {
				System.out.println(" * " + product.getProductName() + " za " + product.getPrice());
			}
			
		} catch(Exception e) {
			System.out.println("Katastrofa " + e);
			e.printStackTrace();
		} finally {
			if(em != null) em.close();
			if(emf != null) emf.close();
		}
	}

}
