package sklep.przyklady;

import java.util.Scanner;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import sklep.model.Product;

public class P2_CzytajProduktyInteraktywnie {

	public static void main(String[] args) {
		EntityManagerFactory emf = null;
		EntityManager em = null;
		try {
			emf = Persistence.createEntityManagerFactory("sklep");
			em = emf.createEntityManager();
			Scanner scanner = new Scanner(System.in);
			System.out.println("Podawaj ID produktów, a zakończ podając 0");
			
			while(true) {
				System.out.print("Podaj ID: ");
				int id = scanner.nextInt();
				if(id == 0) break;
				
				// Operacja find zwraca obiekt podanej klasy o podanym ID (klucz główny w tabeli), jeśli taki obiekt istnieje.
				// Jeśli obiektu o podanym ID nie ma, to zwraca null.
				Product product = em.find(Product.class, id);
				if(product == null) {
					System.out.println("Nie ma produktu o ID " + id);
				} else {
					System.out.println("Odczytałem produkt nr " + id + ": " + product);
					System.out.println(product.getProductName() + " za cenę " + product.getPrice());
					System.out.println("Opis: " + product.getDescription());
				}
			}
		} catch(Exception e) {
			System.out.println("Katastrofa " + e);
			e.printStackTrace();
		} finally {
			if(em != null) em.close();
			if(emf != null) emf.close();
		}
	}

}
