package com.example.demo;

import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WstrzykiwaniePrzezKonstruktor {
	private LogikaKalkulatora logikaKalkulatora;
	
	// Jeśli jedynym dostępnym konstruktorem jest taki, który wymaga parametrów,
	// Spring wywoła własnie ten konstruktor i przekaże wymagane parametry, o ile uda mu się takie obiekty znaleźć.
	// To też jest forma wstrzykiwania zależności.
	// Zauważmy, że działa bez żadnej adnotacji przed tym konstruktorem.
	public WstrzykiwaniePrzezKonstruktor(LogikaKalkulatora logikaKalkulatora) {
		this.logikaKalkulatora = logikaKalkulatora;
	}
	
	@GetMapping(path="/liczenie", produces="text/plain")
	@ResponseBody
	public String liczenie(Long liczba1, Long liczba2, String operacja) {
		return String.valueOf(logikaKalkulatora.oblicz(liczba1, liczba2, operacja));
	}
	
	@GetMapping(path="/historia.txt", produces="text/plain")
	@ResponseBody
	public String dajHistorie() {
		return logikaKalkulatora.getHistoriaDzialan()
				.stream()
				.map(s -> " → " + s)
				.collect(Collectors.joining("\n"));
	}
	
}
