package com.example.demo;

import java.time.LocalTime;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PierwszyKontroler {
	@RequestMapping("/hello")
	@ResponseBody
	public String helloWorld() {
		return "Hello world - jestem Spring";
	}
	
	@RequestMapping("/godzina")
	@ResponseBody
	public String ktoraGodzina() {
		return LocalTime.now().toString();
		// return LocalTime.now();
	}

	@RequestMapping("/ping")
	public String ping(HttpServletRequest request, Model model) {
		// Do metod w kontrolerze można dodawać parametry różnych typów,
		// które "Spring zna" i gdy taki parametr się pojawia, to Spring
		// wywołując metodę przekazuje nam w tym parametrze odpowiedni obiekt.
		// To się nazywa wstrzykiwanie parametrów / parameter injection.
		// A ogólnie to podejście, że nie my wywołuemy metodę, aby coś odczytać,
		// tylko spring wywołuje NASZĄ metodę i Spring NAM przekazuje wymagane parametry,
		// nazywa się "inversion of control" (IoC).

		// Przykładowo tutaj dodaliśmy do metody parametr HttpServletRequest
		// i Spring przekazuje nam tu techniczne informacje o zapytaniu (to samo, co
		// było w serwletach).

		// Do modelu można też dodać słownik / mapę.
		// Odczyt wartości wygląda później np. tak ${clientInfo.userAgent}

		String ip = request.getRemoteAddr();
		String host = request.getRemoteHost();
		System.out.println("Zapytanie z adresu " + ip);

		model.addAttribute("clientInfo", Map.of("userAgent", request.getHeader("User-Agent"), "ip", ip, "host", host));
		return "ping.html";
	}

}
