package sklep.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/Products0")
public class Products0 extends HttpServlet {
	private static final long serialVersionUID = 1L;

	/* W tej wersji serwlet wypisuje dane produktów tekstowo.
	 * W kodzie serwletu bezpośrednio korzytstamy z technologii bazodanowej JDBC,
	 * mamy tutaj fragment SQL, nazwy tabel, kolumn, odczyt pojedynczych pól...
	 * 
	 * Na dłuższą metę tak się nie programuje: byłoby za dużo kodu, mieszalibyśmy wartwę webową z warstwą danych,
	 * mielibyśmy dużo duplikacji kodu pomiędzy różnymi klasami w aplikacji.
	 */
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		try(Connection c = DriverManager.getConnection("jdbc:postgresql://localhost/sklep", "kurs", "abc123");
			Statement stmt = c.createStatement();
			ResultSet rs = stmt.executeQuery("SELECT * FROM products")) {
			
			while(rs.next()) {
				out.printf("Produkt nr %d: %s za cenę %s.",
						rs.getInt("product_id"), rs.getString("product_name"), rs.getBigDecimal("price"));
				
				String opis = rs.getString("description");
				if(opis != null) {
					out.printf(" Opis: %s.", opis);
				}
				out.println();
			}
		} catch (SQLException e) {
			e.printStackTrace(out);
		}
	}

}
