package sklep.basket;

import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@WebListener
public class BasketInitialization implements HttpSessionListener {

	public void sessionCreated(HttpSessionEvent se) {
		// To się wykona, gdy jakaś sesja jest tworzona.
		HttpSession sesja = se.getSession();
		sesja.setMaxInactiveInterval(30); // czas wygaśnięcia sesji w sekundach
		System.out.println("Powstała sesja " + sesja.getId());
		sesja.setAttribute("basket", new Basket());
	}

	public void sessionDestroyed(HttpSessionEvent se) {
		// To się wykona, gdy jakaś sesja jest usuwana (kończy się).
		HttpSession sesja = se.getSession();
		System.out.println("Koniec sesji " + sesja.getId());
	}

}
