package dostep_podstawowy;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WypiszProdukty {

	public static void main(String[] args) {
		final String url = "jdbc:postgresql://localhost:5432/sklep";
		final String user = "kurs";
		final String password = "abc123";
		final String sql = "SELECT * FROM products ORDER BY product_id";		
		
		try(Connection c = DriverManager.getConnection(url , user, password);
			PreparedStatement stmt = c.prepareStatement(sql);
			ResultSet rs = stmt.executeQuery()) {
			
			while(rs.next()) {
				System.out.printf("%3d: %s, cena %.2f, vat %.0f%%, opis: %s\n",
						rs.getInt("product_id"),
						rs.getString("product_name"),
						rs.getBigDecimal("price"),
						rs.getBigDecimal("vat").movePointRight(2), // jeśli nie null
						rs.getString("description"));
			}
		} catch (SQLException e) {
			e.printStackTrace();
		};
	}
}
