package dostep_podstawowy;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.Scanner;

public class DodajProdukt {

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        scanner.useLocale(Locale.US);
        
        final String url = "jdbc:postgresql://localhost:5432/sklep";
		final String user = "kurs";
		final String password = "abc123";
		
		try(Connection c = DriverManager.getConnection(url , user, password)) {
			c.setAutoCommit(false);
            
            while(true) {
                System.out.print("Podaj nazwę nowego produktu (pusty napis, aby zakończyć): ");
                String name = scanner.nextLine();
                if(name.isEmpty())
                    break;
                
                System.out.print("Podaj cenę: ");
                BigDecimal price = scanner.nextBigDecimal();
                scanner.nextLine();
                System.out.print("Podaj stawkę VAT, np 23 : ");
                int vat = scanner.nextInt();
                scanner.nextLine();
                System.out.print("Podaj opis: ");
                String description = scanner.nextLine();
                if(description.isEmpty()) {
                	description = null;
                }
                // aby wpisać rekord do bazy, tworzymy obiekt bez określonego ID
                final String sql = "INSERT INTO products(product_name, price, vat, description) VALUES(?, ?, ?, ?)";
                final String[] kolumnyID = {"product_id"};
                try(PreparedStatement stmt = c.prepareStatement(sql, kolumnyID)) {
	                stmt.setString(1, name);
	                stmt.setBigDecimal(2, price);
	                stmt.setBigDecimal(3, BigDecimal.valueOf(vat).movePointLeft(2));
	                stmt.setString(4, description);
                
	                stmt.executeUpdate();
	                
	                // teraz mogę odczytać wygenerowane ID
	                try(ResultSet rs = stmt.getGeneratedKeys()) {
						if(rs.next()) {
							int id = rs.getInt(1);
							System.out.println("Nowy produkt uzyskał numer " + id);
						}
					}
                }
            }
            System.out.println("Czy zapisać zmiany? [T/N]");
            String wybor = scanner.next().toUpperCase();
            switch(wybor) {
                case "T": 
                    System.out.println("Zatwierdzam transakcję");
                    c.commit();
                    break;
                case "N":
                    System.out.println("Cofam transakcję");
                    c.rollback();
                    break;
                default:
                    System.out.println("Rozłączam się bez zatwierdzenia transakcji");
            }
        } catch(Exception e) {
            e.printStackTrace();
        }       
    }
}
