package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JOptionPane;

public class WypiszJob3 {
	/* Rozwiązanie 3:
	 * Za pomocą WHERE filtrujemy rekordy po stronie bazy danych, co poprawia wydajność.
	 * 
	 * Tutaj prawidłowo używamy parametrów JDBC zapisywanych za pomocą ?
	*/
	public static void main(String[] args) {
		String url = "jdbc:postgresql://localhost:5432/hr";
		try {
			Connection c = DriverManager.getConnection(url, "kurs", "abc123");
			String szukanyJob = JOptionPane.showInputDialog("Podaj kod stanowiska, np. IT_PROG");
			
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees WHERE job_id = ?");
			stmt.setString(1, szukanyJob);
			
			System.out.println("Zaraz wykonam: " + stmt);
			ResultSet rs = stmt.executeQuery();
			
			while(rs.next()) {
				int id = rs.getInt(1);
				String firstName = rs.getString(2);
				String lastName = rs.getString(3);
				String job = rs.getString("job_id");
				BigDecimal salary = rs.getBigDecimal("salary");
				
				System.out.printf("Pracownik nr %d: %s %s (%s), zarabia %s\n",
					id, firstName, lastName, job, salary);
			}
			rs.close();
			stmt.close();
			c.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
