package zajecia.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JOptionPane;

public class Podwyzka4 {

	public static void main(String[] args) {
		final String url = "jdbc:postgresql://localhost/hr";
		final String sqlAvg = "SELECT avg(salary) FROM employees WHERE job_id = ?";
		final String sqlUpdate = "UPDATE employees SET salary = salary + ? WHERE job_id = ?";

		try(Connection c = DriverManager.getConnection(url, "kurs", "abc123");
			PreparedStatement stmtAvg = c.prepareStatement(sqlAvg);
			PreparedStatement stmtUpdate = c.prepareStatement(sqlUpdate)) {
			
			// wyłączenie automatycznego zapisywania zmian, czyli wejście w tryb transakcji
			c.setAutoCommit(false);
			
			String job = JOptionPane.showInputDialog("Podaj kod stanowiska");
			stmtAvg.setString(1, job);
			
			wyliczIWypiszSrednia(stmtAvg);
			
			int zmiana = Integer.parseInt(JOptionPane.showInputDialog("Podaj zmianę pensji:"));
			zmienPensje(stmtUpdate, job, zmiana);
			
			wyliczIWypiszSrednia(stmtAvg);
			
			int wybor = JOptionPane.showConfirmDialog(null, "Czy zatwierdzić zmiany?");
			switch(wybor) {
				case JOptionPane.YES_OPTION -> c.commit();
				case JOptionPane.NO_OPTION -> c.rollback();
				case JOptionPane.CANCEL_OPTION -> {/* nic */}
			}
			
			wyliczIWypiszSrednia(stmtAvg);
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	private static void zmienPensje(PreparedStatement stmtUpdate, String job, int zmiana) throws SQLException {
		stmtUpdate.setInt(1, zmiana);
		stmtUpdate.setString(2, job);
		
		int ile = stmtUpdate.executeUpdate();
		JOptionPane.showMessageDialog(null, "Zmodyfikowano " + ile + " rekordów");
	}

	private static void wyliczIWypiszSrednia(PreparedStatement stmtAvg) throws SQLException {
		try(ResultSet rs = stmtAvg.executeQuery()) {
			if(rs.next()) {
				double srednia = rs.getDouble(1);
				JOptionPane.showMessageDialog(null, "Średnia pensja: " + srednia);
			}
		}
	}

}
