package podstawy;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;

@WebServlet("/Rozmowa")
public class Rozmowa extends HttpServlet {
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// Odczyt parametrów celowo umieszczam na początku metody, aby pokazać, że po wypełnieniu formularza
		// i naciśnięciu Wyślij metoda do Get wykona się ponownie od początku
		
		String imie = request.getParameter("imie");
		String parametrWiek = request.getParameter("wiek");
		System.out.println("rozmowa wywołana z parametrem " + imie);
		
		response.setContentType("text/html");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		out.println("<!DOCTYPE html>");
		out.println("<html><head>");
		out.println("<title>Rozmowa serwletowa</title>");
		out.println("</head>");
		out.println("<body>");
		out.println("<h1>Rozmowa serwletowa</h1>");
		out.println("<form>");
		out.println("<label for='imie'>Jak masz na imię?</label>");
		out.println("<input type='text' name='imie'>");
		out.println("<label for='wiek'>Ile masz lat?</label>");
		out.println("<input type='number' name='wiek'>");
		out.println("<button>Wyślij</button>");
		out.println("</form>");
		
		if(StringUtils.isNotBlank(imie)) {
			out.println("<p>Witaj " + imie + "</p>");
			if(StringUtils.isNotBlank(parametrWiek)) {
				int wiek = Integer.parseInt(parametrWiek);
				if(wiek >= 18) {
					out.println("<p>Zapraszamy na piwo.</p>");
				} else {
					out.println("<p>Osoba niepełnoletnia.</p>");
				}
			}
		}
		
		out.println("</body>");
		out.println("</html>");
	}

}
