package podstawy;

import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/godzina")
public class KtoraGodzinaHtml extends HttpServlet {
	private static final long serialVersionUID = 1L;
    
    @Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		LocalDateTime dt = LocalDateTime.now();
		
		response.setContentType("text/html");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		out.println("<!DOCTYPE html>");
		out.println("<html><head>");
		out.println("<title>Bieżący czas</title>");
		out.println("</head>");
		out.println("<body>");
		out.println("<p>Dzisiejsza data: <strong style='color:blue'>" + dt.toLocalDate() + "</strong></p>");
		out.println("<p>Bieżący czas: <strong style='color:magenta'>" + dt.toLocalTime() + "</strong></p>");
		out.println("</body></html>");
	}

}
