package sprzedaz.wydajnosc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class WyczarujPliki {
	
	public static void main(String[] args) {
		try {
			List<String> linie = Files.readAllLines(Paths.get("sprzedaz.csv"));
			linie.remove(0);
			for(int n : new int[]{1, 10, 100}) {
				String plik = "sprzedaz_"+n+".csv";
				System.out.println(plik);
				zapiszPowielone(linie, n, new File(plik));
			}
			System.out.println("Gotowe");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void zapiszPowielone(List<String> linie, int n, File file) throws FileNotFoundException {
		try(PrintWriter out = new PrintWriter(file)) {
			for(int tura = 0; tura < n; tura ++) {
				for (String linia : linie) {
					out.println(linia);
				}
			}
		}
	}

}
