package sprzedaz.strumieniowo;

import java.util.Comparator;
import java.util.List;

public class B3_FilterMap {

	public static void main(String[] args) {
		List<Transakcja> lista = ObslugaCSV.wczytaj("sprzedaz.csv");

		// filter sprawdza warunek logiczny i "przepuszcza dalej" tylko obiekty spełniające ten warunek
		// map wywołuje podaną metodę na obiekcie i wynik tego wywołania wstawia w miejsce obiektu;
		//   wynikiem mapowania jest strumień składający się z wyników podanej operacji
		// forEach - robi coś dla każdego elementu strumienia
		
		lista.stream()
				.filter(tr -> "Katowice".equals(tr.getMiasto()))
				.sorted(Comparator.comparing(Transakcja::getWartosc).reversed())
				.map(tr -> " * sprzedano " + tr.getSztuk() + " towaru " + tr.getTowar() + " za " + tr.getWartosc())
				.forEach(System.out::println);
	}

}
