package sprzedaz.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class P4_Grupowanie_v3 {
    
    // w tej wersji używam operacji getOrDefault, która pojawiła się w Java 8
    // dzięki temu nie trzeba if-em rozróżniać sytuacji gdy to jest pierwsze lub kolejne wystąpienie danego miatsa
    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");

        Map<String, Double> sumy = new HashMap<>();
        for(Transakcja transakcja : transakcje) {
            double ileBylo = sumy.getOrDefault(transakcja.getMiasto(), 0.0);
            sumy.put(transakcja.getMiasto(), ileBylo + transakcja.getWartoscDouble());
        }
        
        for(Map.Entry<String, Double> entry : sumy.entrySet()) {
            System.out.printf("| %-10s | %11.2f |\n", entry.getKey(), entry.getValue());            
        }
    }

}
