package sprzedaz.obiektowo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class P4_Grupowanie_v2 {
    // drugie podjeście - dane przeglądam tylko raz, a liczby dodaję od razu do słownika pod odpowiednim kluczem
    
    public static void main(String[] args) {
        List<Transakcja> transakcje = ObslugaCSV.wczytaj("sprzedaz.csv");

        Map<String, Double> sumy = new HashMap<>();
        for(Transakcja transakcja : transakcje) {
            if(sumy.containsKey(transakcja.getMiasto())) {
                // update
                double ileBylo = sumy.get(transakcja.getMiasto());
                sumy.put(transakcja.getMiasto(), ileBylo + transakcja.getWartoscDouble());
            } else {
                // insert
                sumy.put(transakcja.getMiasto(), transakcja.getWartoscDouble());
            }
        }
        
        for(Map.Entry<String, Double> entry : sumy.entrySet()) {
            System.out.printf("| %-10s | %11.2f |\n", entry.getKey(), entry.getValue());            
        }
    }

}
