package rozwiazania_zadan.r2.z1.p4_pierwsze;

import java.util.Scanner;

public class LiczbyPierwsze4 {
	
	// W tej wersji osobno sprawdzam podzielność przez 2 jako "bardzo prawdopodobną sytuację"
	// Dzięki temu w pętli mogę iść krokiem o 2 sprawdzając tylko liczby nieparzyste
	// i jeszcze trochę (prawie dwukrotnie) przyspieszam działanie względem wersji 3.
	static boolean czyPierwsza(long liczba) {
		if(liczba == 1) {
			return false;
		}
		if(liczba != 2 && liczba % 2 == 0) {
			return false;
		}
		
		for(long i = 3; i <= Math.sqrt(liczba+1); i += 2) {
			if(liczba % i == 0) {
				return false;
			}
		}
		return true;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		System.out.println("Aby zakończyć, wpisz 0");
		while(true) {
			System.out.print("Podaj liczbę: ");
			long liczba = sc.nextLong();
			if(liczba == 0) break;
			
			// pomiar czasu
			long p = System.currentTimeMillis();
			boolean wynik = czyPierwsza(liczba);
			long k = System.currentTimeMillis();
			
			if(wynik) {
				System.out.println("Liczba " + liczba + " jest pierwsza");
			} else {
				System.out.println("Liczba " + liczba + " nie jest pierwsza");
			}
			System.out.println("Sprawdzenie trwało " + (k-p) + " ms");
			System.out.println();
		}

	}

}
