package alx.p43_files;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class Watchery {

	// WatchService potrafi obserwowac tylko katalogi a nie pojedyncze pliki)
	
	public static void main(String[] args) {
		try {
			Path start = Paths.get("katalog");

			FileSystem fs = start.getFileSystem();
			System.out.println("newWatchService()");
			WatchService ws = fs.newWatchService();
			System.out.println("Register:");
			start.register(ws,
					StandardWatchEventKinds.ENTRY_CREATE,
					StandardWatchEventKinds.ENTRY_DELETE,
					StandardWatchEventKinds.ENTRY_MODIFY,
					StandardWatchEventKinds.OVERFLOW);
			System.out.println("Czekam");
			WatchKey key = ws.take();
			System.out.println("Jest "+key);
			for(WatchEvent<?> event : key.pollEvents()) {
				System.out.println("Event "+event.kind().name() + " "+event.context());
			}
			System.out.println("Koniec");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
