package alx.p43_files;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class Przenoszenie {

	public static void main(String[] args) {
		
		try {
			String skad = "kopia.txt";
			//String dokad = "przeniesione.txt";
			String dokad = "/tmp/przeniesione.txt";
			//String skad = "/home/patryk/kopiowanie/katalog";
			//String dokad = "/home/patryk/katalog_nowy";
			//String dokad = "/tmp/wynik";
			
			Path pskad = Paths.get(skad);
			Path pdokad = Paths.get(dokad);
	
			System.out.println("Przenosze");
			// To działa także przy przenoszeniu jednego pliku na inną partycję.
			Path copy = Files.move(pskad, pdokad);
			
			// ATOMIC_MOVE jest możliwy tylko w obrębie tej samej partycji, a nie zadziała gdy spróbujemy na inną
			// Dodanie opcji ATOMIC_MOVE może spowodować wyjątek w sytuacjach, gdy bez tej opcji wszystko by zadziałało.
			// Path copy = Files.move(pskad, pdokad, StandardCopyOption.ATOMIC_MOVE);
			System.out.println("Przenioslem " + copy);
			
			// przenosi pliki
			// przenosi też katalogi wraz z zawartością
			// ale tylko w obrębie tej samej partycji
		
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

}
