package alx.p31_streamy.emps;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Podzial {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		// Szczególnym rodzajem grupowania jest podział danych na dwie grupy zwn warunek logiczny.
		Map<Boolean, List<Employee>> grupy = emps.stream().collect(
				Collectors.partitioningBy(emp -> emp.getSalary() >= 10_000));
		
		System.out.println("Bogaci:");
		grupy.get(true).forEach(emp -> {
				System.out.println(" * " + emp.getFirstName() + " " + emp.getLastName());
		});
		System.out.println();
		
		System.out.println("Biedni:");
		grupy.get(false).forEach(emp -> {
				System.out.println(" * " + emp.getFirstName() + " " + emp.getLastName());
		});
	}

}
