package alx.p31_streamy.emps;

import java.util.List;
import java.util.OptionalDouble;

import javax.swing.JOptionPane;

public class P4_SredniaJob_v2 {

	public static void main(String[] args) {
		String job = JOptionPane.showInputDialog("Podaj nazwę stanowiska, np. Programmer");
		
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		OptionalDouble srednia = emps.stream()
			.filter(emp -> emp.getJobTitle().equalsIgnoreCase(job))
			.mapToInt(Employee::getSalary)
			.average();
		
		if(srednia.isPresent()) {
			JOptionPane.showMessageDialog(null, "Średnia programistów: " + srednia.getAsDouble());
		} else {
			JOptionPane.showMessageDialog(null, "Nie ma żadnego pracownika na stanowisku " + job, "Brak danych", JOptionPane.WARNING_MESSAGE);
		}
	}

}
