package alx.p31_streamy.emps;

import java.util.List;

// W tej wersji operację forEach wywołujemy bezpośrednio na liście, bez jawnego użycia strumieni.
public class P0_ForEach {

	public static void main(String[] args) {
		List<Employee> emps = ObslugaCSV.wczytaj("emps.csv");
		
		int zmienna = 0;
		
		// Zamiast pisać pętlę for(Employee emp : emps) { ROBOTA; }
		// można wywołać operację forEach i "ROBOTĘ" przekazać w formie wyrażenia lambda:
		
		emps.forEach(emp -> {
			System.out.print(" * ");
			System.out.println(emp.getFirstName() + " " + emp.getLastName());
			// w obrębie wyrażeń lambda nie wolno modyfikować zmiennych lokalnych zdef. przed lambdą
			// zmienna++;
		});
		System.out.println("-----------------");
		
		// Gdy do wykonania jest tylko jedna czynność, można bez nawiasów klamrowych (i bez średnika):
		emps.forEach(emp -> System.out.print(emp.getCity() + ", "));
		System.out.println();
		System.out.println("-----------------");
		System.out.println();
		
		// Jeśli wykonujemy metodę dla całego obiektu, np. System.out.println(emp);
		// to zamiast lambdy możemy użyć referencji do metody
		
		emps.forEach(System.out::println);
	}

}
