package watki.podstawy;

public class Synchronizacja1 {

	public static void main(String[] args) {
		Konto konto = new Konto(1, 1_000_000, new Osoba("Ala", "Kowalska"));
		System.out.println("Początkowy stan konta: " + konto.getSaldo());
		
		Thread wplacacz = new Thread(() -> {
			for(int i = 1; i <= 100_000; i++) {
				konto.wplata(10);
			}
		});

		Thread wyplacacz = new Thread(() -> {
			for(int i = 1; i <= 100_000; i++) {
				try {
					konto.wyplata(10);
				} catch (BrakSrodkow e) {
					System.err.println(e);
				}
			}
		});
		
		System.out.println("Uruchamiam wątki");
		wplacacz.start();
		wyplacacz.start();

		// Aby poczekać, aż wątki się zakończą, używa się metody join.
		// Tutaj main czeka aż zakończą się wątki wplacacz i wyplacacz.
		try {
			wplacacz.join();
			wyplacacz.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		System.out.println("Końcowy stan konta: " + konto.getSaldo());
	}

}
