package com.example.demo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping("/kalkulator")
// Na poziomie klasy podany jest adres, pod którym działa kontroler, a metody wewnątrz tylko określają rodzaj zapytania.
// Gdyby w którejś metodzie też był podany adres, byłoby to traktowane jako dalszy ciąg adresu, np. /kalkulator/historia
public class Kalkulator {
	/* Wstrzykiwanie zależności (dependency injection).
	   W jednym komponencie chcemy używać innego komponentu.
	   Zamiast samodzielnie tworzyć obiekty i je ze sobą wiązać (co w większych aplikacjach jest żmudne), możemy "poprosić" o to Springa.
	   Do pola w tej klasie Spring automatycznie wpisze referencję do obiektu tamtej klasy.
	   Dowiązania z różnych miejsc aplikacji domyślnie prowadzą do jednego wspólnego obiektu (tego singletona / beana / komponentu).
	   
	   Są 3 sposoby wstrzykiwania: przez pole (zmienną, tak jak tutaj), przez setter i przez konstruktor.
	*/
	@Autowired
	private LogikaKalkulatora logika;

	@GetMapping
	public String kalkulatorGet() {
		// Obsługa metody GET - tylko wyświetlenie pustego formularza
		return "kalkulator.html";
	}

	@PostMapping
	public String kalkulatorPost(Model model, Long liczba1, Long liczba2, String operacja) {
		// Obsługa metody POST - zakładamy, że parametry zostały przekazane (a jeśli nie, to będzie wyjątek).
		long wynik = logika.oblicz(liczba1, liczba2, operacja);
		model.addAttribute("wynik", wynik);
		
		return "kalkulator.html";
	}
	
	// Ta metoda będzie działać pod adresem /kalkulator/historia
	@GetMapping("/historia")
	public String wyswietlHistorie(Model model) {
		model.addAttribute("historia", logika.getHistoriaDzialan());
		return "historia.html";
	}

}
