package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

import javax.swing.JOptionPane;

public class WypiszJob1 {
	/* Rozwiązanie 1:
	   Z bazy odczytujemy wszystkie rekordy, a po stronie w Javy, za pomocą equals filtrujemy rekordy i wyświeltlamy tylko te, które spełniają warunek.
	   
	   Problem: niska wydajność.
	   Baza musi odczytać wszystkie rekordy z dysku (nawet, gdyby były zdefinioane indeksy),
	   wszystkie dane są transferowane przez sieć,
	   wszystkie dane są przeglądane przez Javę, co obciąża aplikację kliencką.
	*/
	public static void main(String[] args) {
		String url = "jdbc:postgresql://localhost:5432/hr";
		try {
			Connection c = DriverManager.getConnection(url, "kurs", "abc123");
			
			String szukanyJob = JOptionPane.showInputDialog("Podaj kod stanowiska, np. IT_PROG");
			// TODO wypisz tylko tych pracowników, których job_id jest równy podanemu
			
			PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees");
			ResultSet rs = stmt.executeQuery();
			
			while(rs.next()) {
				int id = rs.getInt(1);
				String firstName = rs.getString(2);
				String lastName = rs.getString(3);
				String job = rs.getString("job_id");
				BigDecimal salary = rs.getBigDecimal("salary");
				
				if(Objects.equals(job, szukanyJob)) {
					System.out.printf("Pracownik nr %d: %s %s (%s), zarabia %s\n",
						id, firstName, lastName, job, salary);
				}
			}
			rs.close();
			stmt.close();
			c.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
