package zajecia.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.swing.JOptionPane;

public class Podwyzka3 {
	// W tej wersji programu zmian dokonujemy w transakcji, co oznacza, że zmieny nie są widoczne dla innych
	// dopóki nie zatwierdzimy ich poleceniem commit.
	// Gdy program kończy się bez commit, to zmiany w ogóle nie są zapisywane.

	public static void main(String[] args) {
		final String url = "jdbc:postgresql://localhost/hr";
		final String sqlSelectAvg = "SELECT avg(salary) FROM employees WHERE job_id = ?";
		final String sqlUpdate = "UPDATE employees SET salary = salary + ? WHERE job_id = ?";

		try(Connection c = DriverManager.getConnection(url, "kurs", "abc123")) {
			// wyłączenie automatycznego zapisywania zmian, czyli wejście w tryb transakcji
			c.setAutoCommit(false);
			
			String job = JOptionPane.showInputDialog("Podaj kod stanowiska");
			try(PreparedStatement stmt = c.prepareStatement(sqlSelectAvg)) {
				stmt.setString(1, job);
				try(ResultSet rs = stmt.executeQuery()) {
					if(rs.next()) {
						double srednia = rs.getDouble(1);
						JOptionPane.showMessageDialog(null, "Średnia pensja: " + srednia);
					}
				}
			}
			
			int zmiana = Integer.parseInt(JOptionPane.showInputDialog("Podaj zmianę pensji:"));
			
			try(PreparedStatement stmt = c.prepareStatement(sqlUpdate)) {
				stmt.setInt(1, zmiana);
				stmt.setString(2, job);
				
				int ile = stmt.executeUpdate();
				JOptionPane.showMessageDialog(null, "Zmodyfikowano " + ile + " rekordów");
			}
			
			try(PreparedStatement stmt = c.prepareStatement(sqlSelectAvg)) {
				stmt.setString(1, job);
				try(ResultSet rs = stmt.executeQuery()) {
					if(rs.next()) {
						double srednia = rs.getDouble(1);
						JOptionPane.showMessageDialog(null, "Średnia pensja: " + srednia);
					}
				}
			}
			
			int wybor = JOptionPane.showConfirmDialog(null, "Czy zatwierdzić zmiany?");
			switch(wybor) {
				case JOptionPane.YES_OPTION -> c.commit();
				case JOptionPane.NO_OPTION -> c.rollback();
				case JOptionPane.CANCEL_OPTION -> {/* nic */}
			}
			
			try(PreparedStatement stmt = c.prepareStatement(sqlSelectAvg)) {
				stmt.setString(1, job);
				try(ResultSet rs = stmt.executeQuery()) {
					if(rs.next()) {
						double srednia = rs.getDouble(1);
						JOptionPane.showMessageDialog(null, "Średnia pensja: " + srednia);
					}
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

}
