package zajecia.postgresql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Odczyt2 {
// Tutaj używamy konstrukcji try-with-resources, dzięki czemu zasoby (Connection, Statement, ResultSet) zostaną zamknięte bez potrzeby pisania close i także w przypadku wyjątku
    public static void main(String[] args) {
        String url = "jdbc:postgresql://localhost:5432/hr";
        try(Connection c = DriverManager.getConnection(url, "kurs", "abc123");
            PreparedStatement stmt = c.prepareStatement("SELECT * FROM employees ORDER BY employee_id");
            ResultSet rs = stmt.executeQuery()) {
            while(rs.next()) {
                int id = rs.getInt(1);
                String firstName = rs.getString(2);
                String lastName = rs.getString(3);
                String job = rs.getString("job_id");
                BigDecimal salary = rs.getBigDecimal("salary");
                
                System.out.printf("| %3d | %-15s | %-15s | %-10s | %8.2f |%n",
                        id, firstName, lastName, job, salary);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

}
