<%@page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@page import="java.time.LocalTime"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Przykład JSP 2</title>
</head>
<body>
<h1>Przykład JSP 2</h1>
<%-- Stosowanie skryptletów, czyli bezpośrednie wstawianie kodu Javy do JSP,
	jest obecnie uważane za złą praktykę, a należy używać sposobów bardziej "wysokopoziomowych", jak:
	- wyrażenia EL ("Expression Language"), czyli ${...}
	- za ich pomocą odwołania do "beanów", czyli obiektów istniejących po strony Javy,
	- biblioteki tagów ("taglibs")
 --%>
 
<h2>Expression Language</h2>
<p>Wynik obliczenia: ${2+3*4}</p>
<p>Parametr imie: ${param.imie}</p>
<hr>

<h2>Beans</h2>
<jsp:useBean id="obiekt" class="beans.ExampleBean"/>
<p>${obiekt}</p><%-- To powoduje wywołanie toString() --%>
<p>napis: ${obiekt.napis}, licznik: ${obiekt.licznik}</p><%-- To powoduje wywołanie obiekt.getNapis() --%>
<p>Licznik po raz drugi: ${obiekt.licznik}</p>
<p>Bieżący czas: ${obiekt.currentTime}</p>
<p>Pola czasu: ${obiekt.currentTime.dayOfWeek}, ${obiekt.currentTime.dayOfYear} dzień roku, sekunda ${obiekt.currentTime.second}</p>
<hr>
<p>Zmieniam tekst...</p>
<jsp:setProperty name="obiekt" property="napis" value="Ola ma ${1+2} psy"/><%-- można też param zamiast value --%>
<p>Teraz tekst jest taki: ${obiekt.napis}</p>

<h2>Taglibs</h2>
<ul>
<c:forEach var="x" items="Ala,Ola,Ela">
<li>Witaj ${x}!</li>
</c:forEach>
</ul>

<p>Liczby: <c:forEach var="i" begin="10" end="20" step="2">${i}, </c:forEach></p>

<%-- Najczęściej dane do forEach są pobierane z jakiegoś beana w formie kolekcji lub tablicy. --%>
<ol>
<c:forEach var="miasto" items="${obiekt.lista}">
<li>${miasto}</li>
</c:forEach>
</ol>

</body>
</html>
