package parametry;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/Parametry")
public class Parametry extends HttpServlet {
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/plain");
		response.setCharacterEncoding("UTF-8");
		PrintWriter out = response.getWriter();
		
		// W zapytaniu mogą zostać przysłane "parametry".
		// W przypadku zapytania typu GET, parametry są zakodowane na końcu ścieżki URL
		// .../adres?parametr1=wartość&parametr2=wartość
		// w przypadku zapytań POST, parametry są przysłane w treści zapytania.
		// W obu sytuacjach wartość parametru można odczytać za pomocą request.getParameter("NAZWA")
		
		String imie = request.getParameter("imie");
		out.println("Witaj " + imie + "!");
		
		String wiekTekstowo = request.getParameter("wiek");
		if(wiekTekstowo != null) {
			int wiek = Integer.parseInt(wiekTekstowo);
			if(wiek >= 18) {
				out.println("Chodź na piwo");
			} else {
				out.println("Może czekoladę?");
			}
		}
	
	}

}
