package sprzedaz.wydajnosc;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.Locale;

// wersja specjalnie najwolniejsza
public class CzytajILicz1 {
	
	static void calaRobota() {
		try {
			File plik = new File("sprzedaz_100.csv");
			List<Transakcja> lista = WczytajSprzedaz1.wczytaj(plik);
					
			Map<String, BigDecimal> sumy = lista.stream()
				.collect(Collectors.groupingBy(Transakcja::getMiasto,
					Collectors.mapping(Transakcja::getWartosc,
						Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
					
				sumy.forEach((k, v) -> System.out.printf(Locale.US, "%12s - %12.2f\n", k, v));
				System.out.println();
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		Pomiary.zmierzCzasDzalania(CzytajILicz1::calaRobota);
		Pomiary.wypiszPamiec();
		System.out.println("gc...");
		System.gc();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
		}
		Pomiary.wypiszPamiec();
	}

}
